/* 
 *  PreviewTimer.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactNumberI;

public class PreviewTimer extends InteractionTimer {

    private static final Logger LOG = Logger.getLogger(PreviewTimer.class);
    private final ContactNumberI todial;

    public PreviewTimer(int timerLength, String interactionID, ContactNumberI todial, InteractionDataGUI gui) {
        super(timerLength, "PreviewTimer", interactionID, gui);
        LOG.trace("Timer started:" + timerLength);
        this.todial = todial;
    }

    @Override
    public void executeExpiryAction() {
        String methodName = "executeExpiryAction() ";
        LOG.info(methodName + " timer expired, dialing first default number in list");
        InteractionExecutor.getInteractionExe().previewDial(getInteractionID(), todial);
    }

}
